/*
* moduleLCD_def.h
*
* Created: 08/06/2014 13:09:57
*  Author: Mourad MKHAKH
*/
#ifndef LCD_MODULE_DEF_H_
#define LCD_MODULE_DEF_H_
#include <avr/io.h>
#include <inttypes.h>

//	boolean value
#define false 0
#define true 1

// HD44780 LCD number of lines and chars : 20x16
#define LCD_LINES 4
#define LCD_CHARS 20

/* HD44780 LCD port connections */
#define LCD_Data_PORT	PORTA	/**< out port for the LCD  Data lines   */
#define LCD_Data_DDR	DDRA	/**< ddr port for the LCD  Data lines   */
#define LCD_Ctrl_PORT	PORTG	/**< out port for Control line         */
#define LCD_Ctrl_DDR	DDRG	/**< ddr port for Control line         */
#define LCD_E_PIN		0		/**< pin  for Enable line     */
#define LCD_RW_PIN		1		/**< pin  for RW line         */
#define LCD_RS_PIN		2		/**< pin  for RS line         */

#define LCD_VO_PORT		PORTD	/**< PORT for VO line         */
#define LCD_VO_DDR		DDRD	/**< DDR for VO line         */
#define LCD_VO_PIN		PD7		/**< pin nbr for VO line         */

/* IOs on Module LCD */
#define IOS_PIN		PINC
#define IOS_PORT	PORTC
#define IOS_DDR		DDRC
#define Enter_btn	PC0
#define Esc_btn		PC1
#define Inc_btn		PC2
#define Down_btn	PC3
#define Up_btn		PC4
#define Dec_btn		PC5
#define Buzzer		PC6
#define LedBckgrnd	PC7


// inialiser les buttons comme des entres
inline void IOS_Inits(){
	IOS_PORT = 0xFF;
	IOS_DDR &= ~((1 << Enter_btn) | (1 << Inc_btn) | (1 << Dec_btn) | (1 << Up_btn) | (1 << Down_btn) | (1 << Esc_btn));
	IOS_DDR |= (1 << LedBckgrnd) | (1<<Buzzer);
	
	LCD_VO_DDR |= 1 <<  LCD_VO_PIN;
}


#define EnterOn (!(IOS_PIN & (1 << Enter_btn)))
#define IncOn (!(IOS_PIN & ( 1 << Inc_btn)))
#define DecOn (!(IOS_PIN & ( 1 << Dec_btn)))
#define UpOn (!(IOS_PIN & ( 1 << Up_btn)))
#define DownOn (!(IOS_PIN & ( 1 << Down_btn)))
#define EscOn (!(IOS_PIN & ( 1 << Esc_btn)))

#define Buzzer_On (IOS_PORT &= ~( 1 << Buzzer))
#define Buzzer_Off (IOS_PORT |= (1 << Buzzer))
#define Buzzer_Toggle IOS_PORT ^= (1 << Buzzer)

#define LedBckgrnd_Off (IOS_PORT &= ~( 1 << LedBckgrnd))
#define LedBckgrnd_On (IOS_PORT |= (1 << LedBckgrnd))
#define LedBckgrnd_Toggle IOS_PORT ^= (1 << LedBckgrnd)

#define LCD_VO_Off (IOS_PORT &= ~( 1 << LCD_VO_PIN))
#define LCD_VO_On (IOS_PORT |= (1 << LCD_VO_PIN))

#endif /* LCD_MODULE_DEF_H_ */
